/***************************************************************************************/
/*                                                                                     */
/*  Girder 3.0 Plugin                                                                  */
/*  Registry interface                                                                 */
/*                                                                                     */
/*  Copyright 2000 (c) Ron Bessems                                                     */
/*  GNU General Public License                                                         */
/*                                                                                     */
/*                                                                                     */
/***************************************************************************************/


#include "uir.h"


#define HardWarePluginKey "Software\\NacreWare\\ARC2000\\UIR"


void SaveSettings()
{
	HKEY key;
	DWORD dwBuf;
	
    if (!(RegCreateKeyEx(HKEY_CURRENT_USER,HardWarePluginKey,
			0,
			NULL,
			REG_OPTION_NON_VOLATILE ,
			KEY_ALL_ACCESS	,
			NULL,
			&key,
			&dwBuf) ==ERROR_SUCCESS))
	{
		MessageBox(0,"Cannot SaveSettings", "Error",0);
		return;
	}
	
	RegSetValueEx(key, "Comport", 0, REG_DWORD, PBYTE(&ComPort), sizeof(ComPort));
	RegSetValueEx(key, "FastInit", 0, REG_BINARY, PBYTE(&FastInit), sizeof(FastInit));
	RegSetValueEx(key, "SkipInit", 0, REG_BINARY, PBYTE(&SkipInit), sizeof(SkipInit));
	RegSetValueEx(key, "StripZeros", 0, REG_BINARY, PBYTE(&StripZeros), sizeof(StripZeros));
	RegSetValueEx(key, "IRSpeed", 0, REG_DWORD, PBYTE(&IRSpeed), sizeof(IRSpeed));	
	RegCloseKey(key);

}


void LoadSettings()
{
	HKEY key;
	DWORD dwType;
	DWORD dwBuf;
	DWORD dwSize;

	
	FastInit=FALSE;
	SkipInit=FALSE;
	StripZeros=FALSE;
	IRSpeed=100;
	ComPort=2;

	if (!(RegOpenKeyEx(HKEY_CURRENT_USER,HardWarePluginKey, 0,KEY_READ,&key)==ERROR_SUCCESS))
	{
		return;
	}

	dwSize=sizeof(dwBuf);
	if (RegQueryValueEx(key, "Comport", NULL, &dwType,PBYTE(&dwBuf),&dwSize)==ERROR_SUCCESS)
	{
		ComPort=dwBuf;
	}

	dwSize=sizeof(dwBuf);
	if (RegQueryValueEx(key, "FastInit", NULL, &dwType,PBYTE(&dwBuf),&dwSize)==ERROR_SUCCESS)
	{
		FastInit=(dwBuf==1);
	}
	dwSize=sizeof(dwBuf);
	if (RegQueryValueEx(key, "SkipInit", NULL, &dwType,PBYTE(&dwBuf),&dwSize)==ERROR_SUCCESS)
	{
		SkipInit=(dwBuf==1);
	}

	dwSize=sizeof(dwBuf);
	if (RegQueryValueEx(key, "StripZeros", NULL, &dwType,PBYTE(&dwBuf),&dwSize)==ERROR_SUCCESS)
	{
		StripZeros=(dwBuf==1);
	}

	dwSize=sizeof(dwBuf);
	if (RegQueryValueEx(key, "IRSPeed",NULL, &dwType,PBYTE(&dwBuf),&dwSize)==ERROR_SUCCESS)
	{
		IRSpeed=dwBuf;
	}
	
	RegCloseKey(key);
}

