/***************************************************************************************/
/*                                                                                     */
/*  Girder 3.0 Plugin                                                                  */
/*  User interface                                                                     */
/*                                                                                     */
/*  Copyright 2000 (c) Ron Bessems                                                     */
/*  GNU General Public License                                                         */
/*                                                                                     */
/*                                                                                     */
/***************************************************************************************/

#define _WIN32_IE 0x0200
#define AppName TEXT("UIR/IRman Plugin")

#include "uir.h"
#include <stdio.h>
#include <commctrl.h>
#include "resource.h"
#include "ircom.h"
#include "settings.h"


/* Local variables */

HWND hApply;
HWND hOk;
HWND hCancel;
HWND hSpeed;
HWND hSkip;
HWND hPort;
HWND hStrip;
HWND hFast;
bool bRegistred=FALSE; /* TRUE if the Windowclass has been registred allready */



/* Control function */					   
					  
bool GetCheck(HWND button)
{
	switch (SendMessage(button, BM_GETCHECK,0,0))
	{
	case BST_CHECKED: return TRUE;
	case BST_UNCHECKED: return FALSE;
	}
	return FALSE;
}
				

void SetCheck(HWND button, bool Checked)
{
	switch (Checked)
	{
	case TRUE: SendMessage(button, BM_SETCHECK, BST_CHECKED,0); break;
	case FALSE: SendMessage(button, BM_SETCHECK, BST_UNCHECKED,0); break;
	}
}

void SaveUISettings()
{
	char buf[200];

	FastInit=GetCheck(hFast);
	SkipInit=GetCheck(hSkip);
	StripZeros=GetCheck(hStrip);
	IRSpeed=SendMessage(hSpeed, TBM_GETPOS,0,0);	
	SendMessage(hPort, WM_GETTEXT, 255, (int) buf);
	ComPort=2;
	if (strcmp(buf, "com1")==0 )
		ComPort=1;
	if (strcmp(buf, "com2")==0 )
		ComPort=2;
	if (strcmp(buf, "com3")==0 )
		ComPort=3;
	if (strcmp(buf, "com4")==0 )
		ComPort=4;
	if (strcmp(buf, "com5")==0 )
		ComPort=5;
	if (strcmp(buf, "com6")==0 )
		ComPort=6;
	if (strcmp(buf, "com7")==0 )
		ComPort=7;
	if (strcmp(buf, "com8")==0 )
		ComPort=8;



	SaveSettings();

	EnableWindow(hApply, FALSE);
}
	   

void LoadUISettings()
{
	LoadSettings();
	
	 SetCheck(hFast, FastInit);
     SetCheck(hSkip, SkipInit);
     SetCheck(hStrip, StripZeros);
     SendMessage(hSpeed, TBM_SETPOS, 1, IRSpeed);
     if (ComPort==1 )
		SendMessage(hPort, CB_SELECTSTRING, 0 , (int)"com1");
	if (ComPort==2 )
		SendMessage(hPort, CB_SELECTSTRING, 0 , (int)"com2");
	if (ComPort==3 )
		SendMessage(hPort, CB_SELECTSTRING, 0 , (int)"com3");
	if (ComPort==4 )
		SendMessage(hPort, CB_SELECTSTRING, 0 , (int)"com4");
	if (ComPort==5 )
		SendMessage(hPort, CB_SELECTSTRING, 0 , (int)"com5");
	if (ComPort==6 )
		SendMessage(hPort, CB_SELECTSTRING, 0 , (int)"com6");
	if (ComPort==7 )
		SendMessage(hPort, CB_SELECTSTRING, 0 , (int)"com7");
	if (ComPort==8 )
		SendMessage(hPort, CB_SELECTSTRING, 0 , (int)"com8");

}

					   
/* Drawing the frame */

void DrawWindow(HDC h)
{
   MoveToEx(h, 5,5,NULL);
   LineTo(h, 5, 190);
   LineTo(h, 370,190);
   LineTo(h, 370, 5);
   LineTo(h, 5,5);
   SelectObject(h,GetStockObject(WHITE_PEN));
   MoveToEx(h,6,6,NULL);
   LineTo(h, 6,191);
   MoveToEx(h,6,191,NULL);
   LineTo(h,371,191);
   LineTo(h, 371,6);
   LineTo(h, 6,6);
}

/* The window message callback stuff */

LRESULT CALLBACK WindowProc(  HWND hwnd,  UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	HDC h;
	PAINTSTRUCT p;
	switch ( uMsg )
	{
	case WM_CREATE:  break;	
	case WM_DESTROY: 
			PostQuitMessage(0); 
			return 0;
		break;
	case WM_PAINT: 
		h=BeginPaint(hwnd,&p);
		DrawWindow(h);
		EndPaint(hwnd, &p);
		break;
	case WM_COMMAND:
		if ( LOWORD(wParam)==100 ) { SaveUISettings();    };  // Apply
		if ( LOWORD(wParam)==110 ) { PostQuitMessage(0);  }; // Cancel
		if ( LOWORD(wParam)==120 ) { SaveUISettings(); PostQuitMessage(0);  }; // Ok
		if ( LOWORD(wParam)==300  ) /* default button */
        {
            SendMessage(hSpeed, TBM_SETPOS, 1, 100);
            EnableWindow(hApply, TRUE);
		}              
        if ( LOWORD(wParam)==160 ) /* allmost all controls */
        {
                      EnableWindow(hApply, TRUE);
                 
		}        
		break;
	 case WM_HSCROLL:
        if ((HWND)lParam==hSpeed )
            EnableWindow(hApply, TRUE);               
        
		break;
	}

	return DefWindowProc(hwnd, uMsg, wParam, lParam);
}
 


bool WinRegister()
{
	WNDCLASS WinC;


	if ( bRegistred ) return TRUE;

	WinC.style= CS_HREDRAW | CS_VREDRAW;
	WinC.lpfnWndProc=(WNDPROC)WindowProc;
	WinC.cbClsExtra=0;
	WinC.cbWndExtra=0;
	WinC.hInstance=hInstance;
	/* WinC.hIcon=LoadIcon(0, IDI_APPLICATION);*/
	WinC.hIcon=LoadIcon(hInstance, MAKEINTRESOURCE(PLUGINICON));
	WinC.hCursor=LoadCursor(0, IDC_ARROW);
	WinC.hbrBackground=(HBRUSH)(COLOR_BTNFACE+1);
	WinC.lpszClassName=AppName;
	WinC.lpszMenuName=NULL;
	return (RegisterClass(&WinC)!=0);
	
}


bool WinCreate()
{
  PCHAR p; 
  HWND hLabel;
  HWND hTemp;

  hWindow=CreateWindow(	 AppName,
                      "UIR/IRman Settings",
                      WS_OVERLAPPEDWINDOW,
                      CW_USEDEFAULT, CW_USEDEFAULT,
                      380,255,
                      0,0,hInstance,NULL );
  if (hWindow!=0)
  {
    ShowWindow(hWindow, SW_SHOW);
    UpdateWindow(hWindow);
  }
  else
  {
	MessageBox(0,"Cannot create window", "Error",0);
	return FALSE;
  }



  hApply= CreateWindowEx(0,
                        "button",
                        "Apply",
                        WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                        280,200,
                        80,25,
                        hWindow,
                        (HMENU)100,
                        hInstance,
                        NULL);

  SendMessage(hApply, WM_SETFONT, (unsigned int)GetStockObject(DEFAULT_GUI_FONT),MAKELPARAM(TRUE, 0));



  hCancel= CreateWindowEx(0,
                        "button",
                        "Cancel",
                        WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                        190,200,
                        80,25,
                        hWindow,
                        (HMENU)110,
                        hInstance,
                        NULL);
  SendMessage(hCancel, WM_SETFONT, (unsigned int)GetStockObject(DEFAULT_GUI_FONT),1);

  hOk= CreateWindowEx(0,
                        "button",
                        "Ok",
                        WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                        100,200,
                        80,25,
                        hWindow,
                        (HMENU)120,
                        hInstance,
                        NULL);
  SendMessage(hOk, WM_SETFONT, (unsigned int)GetStockObject(DEFAULT_GUI_FONT),MAKELPARAM(TRUE, 0));

  hLabel= CreateWindowEx(0,"STATIC",
                          "Comport",
                          WS_CHILD | WS_VISIBLE | SS_LEFTNOWORDWRAP,
                          20,25,
                          60, 30,
                          hWindow,
                          0,
                          hInstance,
                          NULL);

  SendMessage(hLabel, WM_SETFONT, (unsigned int)GetStockObject(DEFAULT_GUI_FONT),1);



  hPort= CreateWindowEx(0,
                        "combobox",
                        "comport",
                        WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST|  CBS_AUTOHSCROLL | CBS_SIMPLE	,
                        80,20,
                        200,100,
                        hWindow,
                        (HMENU)160,
                        hInstance,
                        NULL);
  SendMessage(hPort, WM_SETFONT,(unsigned int) GetStockObject(DEFAULT_GUI_FONT),1);

  p="com1";
  
  SendMessage(hPort, CB_ADDSTRING , 0, int(p));

  p="com2";
  
  SendMessage(hPort, CB_ADDSTRING , 0, int(p));

  p="com3";
  
  SendMessage(hPort, CB_ADDSTRING , 0, int(p));

  p="com4";
  
  SendMessage(hPort, CB_ADDSTRING , 0, int(p));

  p="com5";
  
  SendMessage(hPort, CB_ADDSTRING , 0, int(p));

  p="com6";
  
  SendMessage(hPort, CB_ADDSTRING , 0, int(p));
  
  p="com7";
  
  SendMessage(hPort, CB_ADDSTRING , 0, int(p));

  p="com8";
  
  SendMessage(hPort, CB_ADDSTRING , 0, int(p));


  hFast= CreateWindowEx(0,
                        "button",
                        "Fast UIR Init",
                        WS_CHILD | WS_VISIBLE | BS_AUTOCHECKBOX,
                        80,45,
                        200,25,
                        hWindow,
                        (HMENU)160,
                        hInstance,
                        NULL);
  SendMessage(hFast, WM_SETFONT,(unsigned int) GetStockObject(DEFAULT_GUI_FONT),1);

  hSkip= CreateWindowEx(0,
                        "button",
                        "Skip UIR init check",
                        WS_CHILD | WS_VISIBLE | BS_AUTOCHECKBOX,
                        80,70,
                        200,25,
                        hWindow,
                        (HMENU)160,
                        hInstance,
                        NULL);
  SendMessage(hSkip, WM_SETFONT, (unsigned int)GetStockObject(DEFAULT_GUI_FONT),1);

  hStrip= CreateWindowEx(0,
                        "button",
                        "Strip Zeros from UIR string",
                        WS_CHILD | WS_VISIBLE | BS_AUTOCHECKBOX,
                        80,95,
                        200,25,
                        hWindow,
                        (HMENU)160,
                        hInstance,
                        NULL);
  SendMessage(hStrip, WM_SETFONT, (unsigned int)GetStockObject(DEFAULT_GUI_FONT),1);

  hLabel= CreateWindowEx(0,"STATIC",
                          "IRSpeed",
                          WS_CHILD | WS_VISIBLE | SS_LEFTNOWORDWRAP,
                          20,130,
                          60, 30,
                          hWindow,
                          0,
                          hInstance,
                          NULL);

  SendMessage(hLabel, WM_SETFONT, (unsigned int)GetStockObject(DEFAULT_GUI_FONT),1);

  hTemp= CreateWindowEx(0,
                        "button",
                        "Default",
                        WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                        80,120,
                        80,25,
                        hWindow,
                        (HMENU)300,
                        hInstance,
                        NULL);
  SendMessage(hTemp, WM_SETFONT, (unsigned int)GetStockObject(DEFAULT_GUI_FONT),1);


	
	/* This one should be updated to CommonControls 4.7 */
  InitCommonControls();
  hSpeed= CreateWindowEx(0,
                        TRACKBAR_CLASS,
                        "Trackbar Control",
                        WS_CHILD | WS_VISIBLE | TBS_AUTOTICKS | TBS_ENABLESELRANGE,
                        80,150,
                        200,30,
                        hWindow,
                        (HMENU)310,
                        hInstance,
                        NULL);

  SendMessage(hSpeed, WM_SETFONT, (unsigned int)GetStockObject(DEFAULT_GUI_FONT),1);

  SendMessage(hSpeed, TBM_SETRANGE,1,MAKELONG(50,500));
  SendMessage(hSpeed, TBM_SETPOS, 1 ,400);
  SendMessage(hSpeed, TBM_SETTICFREQ, 25, 1);

  hLabel= CreateWindowEx(0,"STATIC",
                          "Fast",
                          WS_CHILD | WS_VISIBLE | SS_LEFTNOWORDWRAP,
                          20,155,
                          60, 30,
                          hWindow,
                          0,
                          hInstance,
                          NULL);

  SendMessage(hLabel, WM_SETFONT,(unsigned int) GetStockObject(DEFAULT_GUI_FONT),1);

  hLabel= CreateWindowEx(0,"STATIC",
                          "Slow",
                          WS_CHILD | WS_VISIBLE | SS_LEFTNOWORDWRAP,
                          280,155,
                          60, 30,
                          hWindow,
                          0,
                          hInstance,
                          NULL);

  SendMessage(hLabel, WM_SETFONT,(unsigned int) GetStockObject(DEFAULT_GUI_FONT),1);


  LoadUISettings();


  EnableWindow(hApply, FALSE);



  return TRUE;
}


DWORD WINAPI ConfigThread( LPVOID lpParameter )
{
	MSG AMessage;
	
	if (!WinRegister())
	{
		return 0;
	}
	
	bRegistred=TRUE;

	if (!WinCreate() )
	{
		return 0;
	}
	
    while (GetMessage(&AMessage, 0, 0, 0))
	{
      TranslateMessage(&AMessage);
      DispatchMessage(&AMessage);
	}
  
	
    hWindow=0;
	
	
	return 0;
}
