/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main_window.cc
 * Copyright (C) Mike Crash 2008 <mike@mikecrash.com>
 *
 * main.cc is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * main.cc is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <iostream>
#include <sigc++/class_slot.h>
#include <glibmm.h>
#include <config.h>
#include "const.h"
#include "main_window.h"
#include "scan_rate.h"

#define LOGO_FILE "got-logo.png"

// Constructor
MainWindow::MainWindow()
{
	CreateWidgets();
    Drive = new DriveTools();
    ScanBus();
	Scan = NULL;

    //watch the drive media change
    sigc::slot<bool> my_slot = sigc::bind(sigc::mem_fun(*this, &MainWindow::on_timeout), 1);
    sigc::connection conn = Glib::signal_timeout().connect(my_slot, 1000);
}

// Destructor
MainWindow::~MainWindow()
{
    if (Scan)
        delete Scan;
    if (Drive)
        delete Drive;
}

void MainWindow::CreateWidgets(void)
{
    // The window
    set_title("GNOME Optical Tools");
    set_default_size( 500 , 400 );
    set_icon_from_file(PIXMAPS_DIR "/" LOGO_FILE);

	//main box
    Gtk::VBox *main_vbox = manage (new Gtk::VBox(false, 4));
    add(*main_vbox);
        //main menu
        Gtk::MenuBar *main_menu = manage (new Gtk::MenuBar());
        main_vbox->pack_start(*main_menu, false, false, 0);
            //file menu
            Gtk::MenuItem *menu_file = manage (new Gtk::MenuItem("File"));
            main_menu->append(*menu_file);
            Gtk::Menu *menuc_file = manage (new Gtk::Menu());
            menu_file->set_submenu(*menuc_file);
                //file menu items
                Gtk::ImageMenuItem* menu_quit = manage (new Gtk::ImageMenuItem(Gtk::Stock::QUIT));
                menuc_file->append(*menu_quit);
                menu_quit->signal_activate().connect ( sigc::mem_fun(*this, &MainWindow::hide) );
            //help menu
            Gtk::MenuItem *menu_help = manage (new Gtk::MenuItem("Help"));
            main_menu->append(*menu_help);
            Gtk::Menu *menuc_help = manage (new Gtk::Menu());
            menu_help->set_submenu(*menuc_help);
                //file menu items
                Gtk::ImageMenuItem *menu_about = manage (new Gtk::ImageMenuItem(Gtk::Stock::ABOUT));
                menuc_help->append(*menu_about);
                menu_about->signal_activate().connect ( sigc::mem_fun(*this, &MainWindow::on_menu_about_clicked) );
        //toolbar
        Gtk::Toolbar *toolbar = manage (new Gtk::Toolbar());
        main_vbox->pack_start(*toolbar, false, false, 0);
            //quit button
            Gtk::ToolButton *button_quit = manage (new Gtk::ToolButton(Gtk::Stock::QUIT));
            toolbar->append(*button_quit);
            button_quit->signal_clicked().connect ( sigc::mem_fun(*this, &MainWindow::hide) );
            //separator
            Gtk::SeparatorToolItem *separator1 = manage (new Gtk::SeparatorToolItem());
            toolbar->append(*separator1);
            //play button
            button_start = manage (new Gtk::ToolButton(Gtk::Stock::CDROM));
            button_start->set_label("Start");
            toolbar->append(*button_start);
			button_start->set_sensitive(false);
            button_start->signal_clicked().connect ( sigc::mem_fun(*this, &MainWindow::on_button_start_clicked) );
            //stop button
            button_stop = manage (new Gtk::ToolButton(Gtk::Stock::STOP));
            toolbar->append(*button_stop);
			button_stop->set_sensitive(false);
            button_stop->signal_clicked().connect ( sigc::mem_fun(*this, &MainWindow::on_button_stop_clicked) );
            //eject button
            button_eject = manage (new Gtk::ToolButton(Gtk::Stock::GOTO_TOP));
            button_eject->set_label("Eject");
            toolbar->append(*button_eject);
            button_eject->signal_clicked().connect ( sigc::mem_fun(*this, &MainWindow::on_button_eject_clicked) );
            //separator
            Gtk::SeparatorToolItem *separator2 = manage (new Gtk::SeparatorToolItem());
            toolbar->append(*separator2);
            //drive combo
            Gtk::ToolItem *combo_drivetool = manage ( new Gtk::ToolItem());
            toolbar->append(*combo_drivetool);
            Gtk::VBox *combo_drivebox = manage (new Gtk::VBox(true, 1));
            combo_drivetool->add(*combo_drivebox);
            combo_drive = manage ( new Gtk::ComboBoxText());
            combo_drivebox->pack_start(*combo_drive, false, false, 0);
            combo_drive->signal_changed().connect ( sigc::mem_fun(*this, &MainWindow::on_drive_changed) );
            //lock checkbutton
            Gtk::ToolItem *check_locktool = manage ( new Gtk::ToolItem());
            toolbar->append(*check_locktool);
            Gtk::VBox *check_lockbox = manage (new Gtk::VBox(true, 1));
            check_locktool->add(*check_lockbox);
            check_locked = manage ( new Gtk::CheckButton ("locked"));
            check_lockbox->pack_start(*check_locked, false, false, 0);
            check_locked->signal_toggled().connect ( sigc::mem_fun(*this, &MainWindow::on_locked_changed) );
        //notebook
        Gtk::Notebook *notebook = manage (new Gtk::Notebook());
        main_vbox->pack_start(*notebook, true, true, 0);
            //Drive
            Gtk::HBox *notebook_info = manage (new Gtk::HBox(false,3));
            notebook->append_page(*notebook_info,"Drive");
                //Drive info
                Gtk::Frame *notebook_info_frame = manage (new Gtk::Frame("Info"));
                notebook_info->pack_start(*notebook_info_frame, false, false, 0);
                Gtk::Table *notebook_info_table = manage (new Gtk::Table(12,2,false));
                notebook_info_frame->add(*notebook_info_table);
                Gtk::Label *label_vendor = manage ( new Gtk::Label("Vendor:", false));
                notebook_info_table->attach(*label_vendor,0,1,0,1, Gtk::FILL, Gtk::FILL, 2, 2);
                label_vendor->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                info_vendor = manage ( new Gtk::Label("?", false));
                notebook_info_table->attach(*info_vendor,1,2,0,1, Gtk::FILL, Gtk::FILL, 2, 2);
                info_vendor->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_model = manage ( new Gtk::Label("Model:", false));
                notebook_info_table->attach(*label_model,0,1,1,2, Gtk::FILL, Gtk::FILL, 2, 2);
                label_model->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                info_model = manage ( new Gtk::Label("?", false));
                notebook_info_table->attach(*info_model,1,2,1,2, Gtk::FILL, Gtk::FILL, 2, 2);
                info_model->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_firmware = manage ( new Gtk::Label("Firmware:", false));
                notebook_info_table->attach(*label_firmware,0,1,2,3, Gtk::FILL, Gtk::FILL, 2, 2);
                label_firmware->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                info_firmware = manage ( new Gtk::Label("?", false));
                notebook_info_table->attach(*info_firmware,1,2,2,3, Gtk::FILL, Gtk::FILL, 2, 2);
                info_firmware->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_buffer = manage ( new Gtk::Label("Buffer:", false));
                notebook_info_table->attach(*label_buffer,0,1,3,4, Gtk::FILL, Gtk::FILL, 2, 2);
                label_buffer->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                info_buffer = manage ( new Gtk::Label("?", false));
                notebook_info_table->attach(*info_buffer,1,2,3,4, Gtk::FILL, Gtk::FILL, 2, 2);
                info_buffer->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_tla = manage ( new Gtk::Label("TLA#:", false));
                notebook_info_table->attach(*label_tla,0,1,4,5, Gtk::FILL, Gtk::FILL, 2, 2);
                label_tla->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                info_tla = manage ( new Gtk::Label("?", false));
                notebook_info_table->attach(*info_tla,1,2,4,5, Gtk::FILL, Gtk::FILL, 2, 2);
                info_tla->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_sn = manage ( new Gtk::Label("SN#:", false));
                notebook_info_table->attach(*label_sn,0,1,5,6, Gtk::FILL, Gtk::FILL, 2, 2);
                label_sn->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                info_sn = manage ( new Gtk::Label("?", false));
                notebook_info_table->attach(*info_sn,1,2,5,6, Gtk::FILL, Gtk::FILL, 2, 2);
                info_sn->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_iface = manage ( new Gtk::Label("Interface:", false));
                notebook_info_table->attach(*label_iface,0,1,6,7, Gtk::FILL, Gtk::FILL, 2, 2);
                label_iface->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                info_iface = manage ( new Gtk::Label("?", false));
                notebook_info_table->attach(*info_iface,1,2,6,7, Gtk::FILL, Gtk::FILL, 2, 2);
                info_iface->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_loader = manage ( new Gtk::Label("Loader:", false));
                notebook_info_table->attach(*label_loader,0,1,7,8, Gtk::FILL, Gtk::FILL, 2, 2);
                label_loader->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                info_loader = manage ( new Gtk::Label("?", false));
                notebook_info_table->attach(*info_loader,1,2,7,8, Gtk::FILL, Gtk::FILL, 2, 2);
                info_loader->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_rpc = manage ( new Gtk::Label("RPC phase:", false));
                notebook_info_table->attach(*label_rpc,0,1,8,9, Gtk::FILL, Gtk::FILL, 2, 2);
                label_rpc->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                info_rpc = manage ( new Gtk::Label("?", false));
                notebook_info_table->attach(*info_rpc,1,2,8,9, Gtk::FILL, Gtk::FILL, 2, 2);
                info_rpc->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_region = manage ( new Gtk::Label("Region:", false));
                notebook_info_table->attach(*label_region,0,1,9,10, Gtk::FILL, Gtk::FILL, 2, 2);
                label_region->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                info_region = manage ( new Gtk::Label("?", false));
                notebook_info_table->attach(*info_region,1,2,9,10, Gtk::FILL, Gtk::FILL, 2, 2);
                info_region->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_userchng = manage ( new Gtk::Label("User changes:", false));
                notebook_info_table->attach(*label_userchng,0,1,10,11, Gtk::FILL, Gtk::FILL, 2, 2);
                label_rpc->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                info_userchng = manage ( new Gtk::Label("?", false));
                notebook_info_table->attach(*info_userchng,1,2,10,11, Gtk::FILL, Gtk::FILL, 2, 2);
                info_userchng->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_vendorrst = manage ( new Gtk::Label("Vendor resets:", false));
                notebook_info_table->attach(*label_vendorrst,0,1,11,12, Gtk::FILL, Gtk::FILL, 2, 2);
                label_vendorrst->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                info_vendorrst = manage ( new Gtk::Label("?", false));
                notebook_info_table->attach(*info_vendorrst,1,2,11,12, Gtk::FILL, Gtk::FILL, 2, 2);
                info_vendorrst->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);

                //Capabilities info
                Gtk::Frame *notebook_cap_frame = manage (new Gtk::Frame("Capabilities"));
                notebook_info->pack_start(*notebook_cap_frame, false, false, 0);
                Gtk::Table *notebook_cap_table = manage (new Gtk::Table(15,3,false));
                notebook_cap_frame->add(*notebook_cap_table);
                Gtk::Label *label_capread = manage ( new Gtk::Label(" Read ", false));
                notebook_cap_table->attach(*label_capread,0,1,0,1, Gtk::FILL, Gtk::FILL, 2, 2);
                Gtk::Label *label_capwrite = manage ( new Gtk::Label(" Write ", false));
                notebook_cap_table->attach(*label_capwrite,1,2,0,1, Gtk::FILL, Gtk::FILL, 2, 2);
                info_cdr_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_cdr_r,0,1,1,2, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                info_cdr_w = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_cdr_w,1,2,1,2, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capcdr = manage ( new Gtk::Label("CD-R", false));
                label_capcdr->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capcdr,2,3,1,2, Gtk::FILL, Gtk::FILL, 2, 2);
                info_cdrw_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_cdrw_r,0,1,2,3, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                info_cdrw_w = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_cdrw_w,1,2,2,3, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capcdrw = manage ( new Gtk::Label("CD-RW", false));
                label_capcdrw->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capcdrw,2,3,2,3, Gtk::FILL, Gtk::FILL, 2, 2);
                info_ddcdr_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_ddcdr_r,0,1,3,4, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                info_ddcdr_w = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_ddcdr_w,1,2,3,4, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capddcdr = manage ( new Gtk::Label("DDCD-R", false));
                label_capddcdr->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capddcdr,2,3,3,4, Gtk::FILL, Gtk::FILL, 2, 2);
                info_ddcdrw_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_ddcdrw_r,0,1,4,5, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                info_ddcdrw_w = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_ddcdrw_w,1,2,4,5, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capddcdrw = manage ( new Gtk::Label("DDCD-RW", false));
                label_capddcdrw->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capddcdrw,2,3,4,5, Gtk::FILL, Gtk::FILL, 2, 2);
                info_mrain_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_mrain_r,0,1,5,6, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                info_mrain_w = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_mrain_w,1,2,5,6, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capmrain = manage ( new Gtk::Label("Mount rainier", false));
                label_capmrain->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capmrain,2,3,5,6, Gtk::FILL, Gtk::FILL, 2, 2);
                info_dvdrom_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrom_r,0,1,6,7, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capdvdrom = manage ( new Gtk::Label("DVD-ROM", false));
                label_capdvdrom->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capdvdrom,2,3,6,7, Gtk::FILL, Gtk::FILL, 2, 2);
                info_dvdram_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdram_r,0,1,7,8, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                info_dvdram_w = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdram_w,1,2,7,8, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capdvdram = manage ( new Gtk::Label("DVD-RAM", false));
                label_capdvdram->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capdvdram,2,3,7,8, Gtk::FILL, Gtk::FILL, 2, 2);
                info_dvdrm_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrm_r,0,1,8,9, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                info_dvdrm_w = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrm_w,1,2,8,9, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capdvdrm = manage ( new Gtk::Label("DVD-R", false));
                label_capdvdrm->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capdvdrm,2,3,8,9, Gtk::FILL, Gtk::FILL, 2, 2);
                info_dvdrwm_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrwm_r,0,1,9,10, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                info_dvdrwm_w = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrwm_w,1,2,9,10, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capdvdrwm = manage ( new Gtk::Label("DVD-RW", false));
                label_capdvdrwm->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capdvdrwm,2,3,9,10, Gtk::FILL, Gtk::FILL, 2, 2);
                info_dvdrdlm_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrdlm_r,0,1,10,11, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                info_dvdrdlm_w = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrdlm_w,1,2,10,11, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capdvdrdlm = manage ( new Gtk::Label("DVD-R DL", false));
                label_capdvdrdlm->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capdvdrdlm,2,3,10,11, Gtk::FILL, Gtk::FILL, 2, 2);
                info_dvdrp_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrp_r,0,1,11,12, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                info_dvdrp_w = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrp_w,1,2,11,12, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capdvdrp = manage ( new Gtk::Label("DVD+R", false));
                label_capdvdrp->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capdvdrp,2,3,11,12, Gtk::FILL, Gtk::FILL, 2, 2);
                info_dvdrwp_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrwp_r,0,1,12,13, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                info_dvdrwp_w = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrwp_w,1,2,12,13, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capdvdrwp = manage ( new Gtk::Label("DVD+RW", false));
                label_capdvdrwp->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capdvdrwp,2,3,12,13, Gtk::FILL, Gtk::FILL, 2, 2);
                info_dvdrdlp_r = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrdlp_r,0,1,13,14, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                info_dvdrdlp_w = manage (new Gtk::Image ());
                notebook_cap_table->attach(*info_dvdrdlp_w,1,2,13,14, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_capdvdrdlp = manage ( new Gtk::Label("DVD+R DL", false));
                label_capdvdrdlp->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_cap_table->attach(*label_capdvdrdlp,2,3,13,14, Gtk::FILL, Gtk::FILL, 2, 2);

                //Functions info
                Gtk::Frame *notebook_func_frame = manage (new Gtk::Frame("Functions"));
                notebook_info->pack_start(*notebook_func_frame, false, false, 0);
                Gtk::Table *notebook_func_table = manage (new Gtk::Table(15,4,false));
                notebook_func_frame->add(*notebook_func_table);
                info_removable = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_removable,0,1,0,1, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_removable = manage ( new Gtk::Label("Removable media", false));
                label_removable->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_removable,1,2,0,1, Gtk::FILL, Gtk::FILL, 2, 2);
                info_embchanger = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_embchanger,0,1,1,2, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_embchanger = manage ( new Gtk::Label("Embedded changer", false));
                label_embchanger->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_embchanger,1,2,1,2, Gtk::FILL, Gtk::FILL, 2, 2);
                info_sidechange = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_sidechange,0,1,2,3, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_sidechange = manage ( new Gtk::Label("Side change", false));
                label_sidechange->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_sidechange,1,2,2,3, Gtk::FILL, Gtk::FILL, 2, 2);
                info_audiocdplay = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_audiocdplay,0,1,3,4, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_audiocdplay = manage ( new Gtk::Label("AudioCD play", false));
                label_audiocdplay->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_audiocdplay,1,2,3,4, Gtk::FILL, Gtk::FILL, 2, 2);
                info_composite = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_composite,0,1,4,5, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_composite = manage ( new Gtk::Label("Composite output", false));
                label_composite->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_composite,1,2,4,5, Gtk::FILL, Gtk::FILL, 2, 2);
                info_digital1 = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_digital1,0,1,5,6, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_digital1 = manage ( new Gtk::Label("Digital port 1", false));
                label_digital1->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_digital1,1,2,5,6, Gtk::FILL, Gtk::FILL, 2, 2);
                info_digital2 = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_digital2,0,1,6,7, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_digital2 = manage ( new Gtk::Label("Digital port 2", false));
                label_digital2->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_digital2,1,2,6,7, Gtk::FILL, Gtk::FILL, 2, 2);
                info_multisession = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_multisession,0,1,7,8, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_multisession = manage ( new Gtk::Label("Multisession", false));
                label_multisession->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_multisession,1,2,7,8, Gtk::FILL, Gtk::FILL, 2, 2);
                info_mode2form1 = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_mode2form1,0,1,8,9, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_mode2form1 = manage ( new Gtk::Label("Mode 2 Form 1", false));
                label_mode2form1->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_mode2form1,1,2,8,9, Gtk::FILL, Gtk::FILL, 2, 2);
                info_mode2form2 = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_mode2form2,0,1,9,10, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_mode2form2 = manage ( new Gtk::Label("Mode 2 Form 2", false));
                label_mode2form2->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_mode2form2,1,2,9,10, Gtk::FILL, Gtk::FILL, 2, 2);
                info_isrcread = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_isrcread,0,1,10,11, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_isrcread = manage ( new Gtk::Label("ISRC read", false));
                label_isrcread->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_isrcread,1,2,10,11, Gtk::FILL, Gtk::FILL, 2, 2);
                info_upcread = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_upcread,0,1,11,12, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_upcread = manage ( new Gtk::Label("UPC read", false));
                label_upcread->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_upcread,1,2,11,12, Gtk::FILL, Gtk::FILL, 2, 2);
                info_barcoderead = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_barcoderead,0,1,12,13, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_barcoderead = manage ( new Gtk::Label("Bar code read", false));
                label_barcoderead->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_barcoderead,1,2,12,13, Gtk::FILL, Gtk::FILL, 2, 2);
                info_morphing = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_morphing,0,1,13,14, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_morphing = manage ( new Gtk::Label("Morphing", false));
                label_morphing->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_morphing,1,2,13,14, Gtk::FILL, Gtk::FILL, 2, 2);

                info_dae = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_dae,2,3,0,1, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_dae = manage ( new Gtk::Label("Digital audio extraction", false));
                label_dae->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_dae,3,4,0,1, Gtk::FILL, Gtk::FILL, 2, 2);
                info_accurate = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_accurate,2,3,1,2, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_accurate = manage ( new Gtk::Label("Accurate stream", false));
                label_accurate->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_accurate,3,4,1,2, Gtk::FILL, Gtk::FILL, 2, 2);
                info_c2err = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_c2err,2,3,2,3, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_c2err = manage ( new Gtk::Label("C2 error reporting", false));
                label_c2err->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_c2err,3,4,2,3, Gtk::FILL, Gtk::FILL, 2, 2);
                info_cdtext = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_cdtext,2,3,3,4, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_cdtext = manage ( new Gtk::Label("CD-text", false));
                label_cdtext->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_cdtext,3,4,3,4, Gtk::FILL, Gtk::FILL, 2, 2);
                info_stream = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_stream,2,3,4,5, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_stream = manage ( new Gtk::Label("Streaming", false));
                label_stream->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_stream,3,4,4,5, Gtk::FILL, Gtk::FILL, 2, 2);
                info_dvdcprm = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_dvdcprm,2,3,5,6, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_dvdcprm = manage ( new Gtk::Label("DVD CPRM", false));
                label_dvdcprm->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_dvdcprm,3,4,5,6, Gtk::FILL, Gtk::FILL, 2, 2);
                info_dvdcss = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_dvdcss,2,3,6,7, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_dvdcss = manage ( new Gtk::Label("DVD CSS/CPPM", false));
                label_dvdcss->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_dvdcss,3,4,6,7, Gtk::FILL, Gtk::FILL, 2, 2);
                info_microcode = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_microcode,2,3,7,8, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_microcode = manage ( new Gtk::Label("Microcode upgradable", false));
                label_microcode->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_microcode,3,4,7,8, Gtk::FILL, Gtk::FILL, 2, 2);
                info_testwr = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_testwr,2,3,8,9, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_testwr = manage ( new Gtk::Label("Test write", false));
                label_testwr->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_testwr,3,4,8,9, Gtk::FILL, Gtk::FILL, 2, 2);
                info_smart = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_smart,2,3,9,10, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_smart = manage ( new Gtk::Label("S.M.A.R.T.", false));
                label_smart->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_smart,3,4,9,10, Gtk::FILL, Gtk::FILL, 2, 2);
                info_defectmng = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_defectmng,2,3,10,11, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_defectmng = manage ( new Gtk::Label("Defect management", false));
                label_defectmng->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_defectmng,3,4,10,11, Gtk::FILL, Gtk::FILL, 2, 2);
                info_pwrmng = manage (new Gtk::Image ());
                notebook_func_table->attach(*info_pwrmng,2,3,11,12, Gtk::SHRINK, Gtk::SHRINK, 0, 0);
                Gtk::Label *label_pwrmng = manage ( new Gtk::Label("Power management", false));
                label_pwrmng->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                notebook_func_table->attach(*label_pwrmng,3,4,11,12, Gtk::FILL, Gtk::FILL, 2, 2);
            //Media
            Gtk::HBox *notebook_media = manage (new Gtk::HBox(false,2));
            notebook->append_page(*notebook_media,"Media");
                //Media info
                Gtk::Frame *notebook_mediainfo_frame = manage (new Gtk::Frame("Info"));
                notebook_media->pack_start(*notebook_mediainfo_frame, false, false, 0);
                Gtk::Table *notebook_mediainfo_table = manage (new Gtk::Table(12,2,false));
                notebook_mediainfo_frame->add(*notebook_mediainfo_table);
                Gtk::Label *label_disctype = manage ( new Gtk::Label("Disc type:", false));
                notebook_mediainfo_table->attach(*label_disctype,0,1,0,1, Gtk::FILL, Gtk::FILL, 2, 2);
                label_disctype->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_disctype = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_disctype,1,2,0,1, Gtk::FILL, Gtk::FILL, 2, 2);
                media_disctype->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_booktype = manage ( new Gtk::Label("Book type:", false));
                notebook_mediainfo_table->attach(*label_booktype,0,1,1,2, Gtk::FILL, Gtk::FILL, 2, 2);
                label_booktype->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_booktype = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_booktype,1,2,1,2, Gtk::FILL, Gtk::FILL, 2, 2);
                media_booktype->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_mediaid = manage ( new Gtk::Label("Media ID:", false));
                notebook_mediainfo_table->attach(*label_mediaid,0,1,2,3, Gtk::FILL, Gtk::FILL, 2, 2);
                label_mediaid->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_mid = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_mid,1,2,2,3, Gtk::FILL, Gtk::FILL, 2, 2);
                media_mid->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_state = manage ( new Gtk::Label("Disc state:", false));
                notebook_mediainfo_table->attach(*label_state,0,1,3,4, Gtk::FILL, Gtk::FILL, 2, 2);
                label_state->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_state = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_state,1,2,3,4, Gtk::FILL, Gtk::FILL, 2, 2);
                media_state->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_lastses = manage ( new Gtk::Label("Last session:", false));
                notebook_mediainfo_table->attach(*label_lastses,0,1,4,5, Gtk::FILL, Gtk::FILL, 2, 2);
                label_lastses->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_lastses = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_lastses,1,2,4,5, Gtk::FILL, Gtk::FILL, 2, 2);
                media_lastses->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_burner = manage ( new Gtk::Label("Burner:", false));
                notebook_mediainfo_table->attach(*label_burner,0,1,5,6, Gtk::FILL, Gtk::FILL, 2, 2);
                label_burner->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_burner = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_burner,1,2,5,6, Gtk::FILL, Gtk::FILL, 2, 2);
                media_burner->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_totalsize = manage ( new Gtk::Label("Total size:", false));
                notebook_mediainfo_table->attach(*label_totalsize,0,1,6,7, Gtk::FILL, Gtk::FILL, 2, 2);
                label_totalsize->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_totalsize = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_totalsize,1,2,6,7, Gtk::FILL, Gtk::FILL, 2, 2);
                media_totalsize->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_readsize = manage ( new Gtk::Label("Readable size:", false));
                notebook_mediainfo_table->attach(*label_readsize,0,1,7,8, Gtk::FILL, Gtk::FILL, 2, 2);
                label_readsize->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_readsize = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_readsize,1,2,7,8, Gtk::FILL, Gtk::FILL, 2, 2);
                media_readsize->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_freesize = manage ( new Gtk::Label("Free size:", false));
                notebook_mediainfo_table->attach(*label_freesize,0,1,8,9, Gtk::FILL, Gtk::FILL, 2, 2);
                label_freesize->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_freesize = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_freesize,1,2,8,9, Gtk::FILL, Gtk::FILL, 2, 2);
                media_freesize->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_erasable = manage ( new Gtk::Label("Erasable:", false));
                notebook_mediainfo_table->attach(*label_erasable,0,1,9,10, Gtk::FILL, Gtk::FILL, 2, 2);
                label_erasable->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_erasable = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_erasable,1,2,9,10, Gtk::FILL, Gtk::FILL, 2, 2);
                media_erasable->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_layers = manage ( new Gtk::Label("Layers:", false));
                notebook_mediainfo_table->attach(*label_layers,0,1,10,11, Gtk::FILL, Gtk::FILL, 2, 2);
                label_layers->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_layers = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_layers,1,2,10,11, Gtk::FILL, Gtk::FILL, 2, 2);
                media_layers->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_sessions = manage ( new Gtk::Label("Sessions:", false));
                notebook_mediainfo_table->attach(*label_sessions,0,1,11,12, Gtk::FILL, Gtk::FILL, 2, 2);
                label_sessions->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_sessions = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_sessions,1,2,11,12, Gtk::FILL, Gtk::FILL, 2, 2);
                media_sessions->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                Gtk::Label *label_tracks = manage ( new Gtk::Label("Tracks:", false));
                notebook_mediainfo_table->attach(*label_tracks,0,1,12,13, Gtk::FILL, Gtk::FILL, 2, 2);
                label_tracks->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                media_tracks = manage ( new Gtk::Label("?", false));
                notebook_mediainfo_table->attach(*media_tracks,1,2,12,13, Gtk::FILL, Gtk::FILL, 2, 2);
                media_tracks->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
    
                //Media tracks
                Gtk::Frame *notebook_mediatracks_frame = manage (new Gtk::Frame("Tracks"));
                notebook_media->pack_start(*notebook_mediatracks_frame, true, true, 0);
                //tracks_columns = manage (new TracksColumns());
                //tracks_store = manage (new Gtk::TreeStore(*tracks_columns);
                tracks_store = Gtk::TreeStore::create(tracks_columns);
                tracks_view = manage (new Gtk::TreeView(tracks_store));
                notebook_mediatracks_frame->add(*tracks_view);
                tracks_view->append_column("Track", tracks_columns.col_track);
                tracks_view->append_column("Type", tracks_columns.col_type);
                tracks_view->append_column("Size", tracks_columns.col_size);
                tracks_view->append_column("Begin", tracks_columns.col_begin);
                tracks_view->append_column("End", tracks_columns.col_end);
            //Transfer rate
            Gtk::HBox *notebook_trate = manage (new Gtk::HBox(false,2));
            notebook->append_page(*notebook_trate,"Transfer rate");
                //Transfer rate info
                Gtk::Table *notebook_trate_table = manage (new Gtk::Table(7,2,false));
                notebook_trate->pack_start(*notebook_trate_table, false, false, 5);
                Gtk::Label *label_scantime = manage ( new Gtk::Label("Scan time:", false));
                notebook_trate_table->attach(*label_scantime,0,1,0,1, Gtk::FILL, Gtk::FILL, 2, 2);
                label_scantime->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                trate_scantime = manage ( new Gtk::Label("?", false));
                notebook_trate_table->attach(*trate_scantime,1,2,0,1, Gtk::FILL, Gtk::FILL, 2, 2);
                trate_scantime->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);

                Gtk::Label *label_scanstart = manage ( new Gtk::Label("Start:", false));
                notebook_trate_table->attach(*label_scanstart,0,1,1,2, Gtk::FILL, Gtk::FILL, 2, 2);
                label_scanstart->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                trate_start_d = manage ( new Gtk::Label("?", false));
                notebook_trate_table->attach(*trate_start_d,1,2,1,2, Gtk::FILL, Gtk::FILL, 2, 2);
                trate_start_d->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                trate_start_r = manage ( new Gtk::Label("?", false));
                notebook_trate_table->attach(*trate_start_r,1,2,2,3, Gtk::FILL, Gtk::FILL, 2, 2);
                trate_start_r->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
	
                Gtk::Label *label_scanend = manage ( new Gtk::Label("End:", false));
                notebook_trate_table->attach(*label_scanend,0,1,3,4, Gtk::FILL, Gtk::FILL, 2, 2);
                label_scanend->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                trate_end_d = manage ( new Gtk::Label("?", false));
                notebook_trate_table->attach(*trate_end_d,1,2,3,4, Gtk::FILL, Gtk::FILL, 2, 2);
                trate_end_d->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                trate_end_r = manage ( new Gtk::Label("?", false));
                notebook_trate_table->attach(*trate_end_r,1,2,4,5, Gtk::FILL, Gtk::FILL, 2, 2);
                trate_end_r->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
	
                Gtk::Label *label_scanavg = manage ( new Gtk::Label("Avg:", false));
                notebook_trate_table->attach(*label_scanavg,0,1,5,6, Gtk::FILL, Gtk::FILL, 2, 2);
                label_scanavg->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                trate_avg_d = manage ( new Gtk::Label("?", false));
                notebook_trate_table->attach(*trate_avg_d,1,2,5,6, Gtk::FILL, Gtk::FILL, 2, 2);
                trate_avg_d->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
                trate_avg_r = manage ( new Gtk::Label("?", false));
                notebook_trate_table->attach(*trate_avg_r,1,2,6,7, Gtk::FILL, Gtk::FILL, 2, 2);
                trate_avg_r->set_alignment(Gtk::ALIGN_LEFT, Gtk::ALIGN_CENTER);
	
				//Transfer rate graph
                trate_curve = manage (new CGraph());
                notebook_trate->pack_start(*trate_curve, true, true, 5);
				trate_curve->set_units("MB","x");
				//trate_curve->set_limits(0,hscaleCD,0,60);

        //status bar
        Gtk::Statusbar *statusbar = manage (new Gtk::Statusbar());
        main_vbox->pack_start(*statusbar, false, false, 0);

    show_all();
}

// Signal
void MainWindow::on_button_eject_clicked()
{
    Drive->Eject();
}

void MainWindow::on_menu_about_clicked()
{
  Gtk::AboutDialog about_dialog;
  about_dialog.set_name("GNOME Optical Tools");
  about_dialog.set_website("http://www.mikecrash.com");
  about_dialog.set_website_label("Mike Crash Homepage");
  about_dialog.set_copyright("Copyright © 2008 by Mike Crash");
  about_dialog.set_version(VERSION);
  about_dialog.set_comments("Tools for optical drive and disc checking");
  about_dialog.set_logo( Gdk::Pixbuf::create_from_file(PIXMAPS_DIR "/" LOGO_FILE));
  about_dialog.run();
}

void MainWindow::on_drive_changed()
{
    int drvnum;
    if (suspend) return;
    drvnum = combo_drive->get_active_row_number();
    Drive->SetDrive(drvnum);
    UpdateDriveInfo();
}

void MainWindow::on_locked_changed()
{
    if (suspend) return;
	if (check_locked->get_active()) 
        Drive->drive->parms.status |= STATUS_LOCK;
	else 
        Drive->drive->parms.status &= (~STATUS_LOCK);
	Drive->set_lock();
}

void MainWindow::on_button_start_clicked()
{
	button_start->set_sensitive(false);
	button_stop->set_sensitive(true);
	trate_start_d->set_label("?");
	trate_start_r->set_label("?");
	trate_end_d->set_label("?");
	trate_end_r->set_label("?");
	trate_avg_d->set_label("?");
	trate_avg_r->set_label("?");
	trate_scantime->set_label("0:00");
	Scan = new CScanRate();
	Scan->set_drive(Drive->drive);
	Scan->signal_dispatcher.connect ( sigc::mem_fun(*this, &MainWindow::on_scan_status) );
	Scan->run();
}

void MainWindow::on_button_stop_clicked()
{
	if (Scan)
		Scan->stop();
}

bool MainWindow::on_timeout(int timer_number)
{
    // media wather
    if (Drive->drive)
    {
		Drive->get_media_status();
	    switch (Drive->drive->parms.event)
        {
		    case EVENT_MEDIA_NEW:
			    printf("Watcher: [%s] %s %s: new media\n", Drive->drive->device, Drive->drive->ven, Drive->drive->dev);
                UpdateMediaInfo();
			    break;
		    case EVENT_MEDIA_REMOVED:
			    printf("Watcher: [%s] %s %s: media removed\n", Drive->drive->device, Drive->drive->ven, Drive->drive->dev);
                UpdateMediaInfo();
			    break;
	    }
		Drive->drive->parms.event = EVENT_NO_CHANGE;
    }
    
    // Keep going (do not disconnect yet):
    return true;
}

void MainWindow::on_scan_status()
{
	switch (Scan->signal_status)
	{
		case SSTAT_START:
		{
			trate_curve->set_limits(0,Scan->get_max_x(),0,Scan->get_max_y());
			trate_curve->set_maxcnt(Scan->get_limit());
			break;
		}
		case SSTAT_UPDATE:
		{
			float *buf;
			int cnt,size;
			char s[100];
			int t = Scan->get_scantime();
			sprintf(s,"%1.1fx",Scan->get_start1());
			trate_start_d->set_label(s);
			sprintf(s,"%1.0fkB/s",Scan->get_start2());
			trate_start_r->set_label(s);
			sprintf(s,"%1.1fx",Scan->get_end1());
			trate_end_d->set_label(s);
			sprintf(s,"%1.0fkB/s",Scan->get_end2());
			trate_end_r->set_label(s);
			sprintf(s,"%d:%02d",t/60,t%60);
			trate_scantime->set_label(s);
					
			if ((buf = Scan->get_buffer()) && (cnt = Scan->get_count()) && (size = Scan->get_size()))
			{
				trate_curve->draw_graph(buf, cnt, size);
			}
			break;
		}
		case SSTAT_DONE:
		{
			char s[100];
			int t = Scan->get_scantime();
			button_start->set_sensitive(true);
			button_stop->set_sensitive(false);
			sprintf(s,"%1.1fx",Scan->get_end1());
			trate_end_d->set_label(s);
			sprintf(s,"%1.0fkB/s",Scan->get_end2());
			trate_end_r->set_label(s);
			sprintf(s,"%1.1fx",Scan->get_avg1());
			trate_avg_d->set_label(s);
			sprintf(s,"%1.0fkB/s",Scan->get_avg2());
			trate_avg_r->set_label(s);
			sprintf(s,"%d:%02d",t/60,t%60);
			trate_scantime->set_label(s);
			break;
		}
		case SSTAT_ABORT:
		{
			button_start->set_sensitive(true);
			button_stop->set_sensitive(false);
			Gtk::MessageDialog msgdialog(*this, "Test aborted",false, Gtk::MESSAGE_INFO, Gtk::BUTTONS_OK, true);
			msgdialog.set_secondary_text("Transfer rate test was aborted.");
			msgdialog.run();
			Scan->signal_status = SSTAT_NONE;
			break;
		}
	}
}

//-----------------
void MainWindow::ScanBus(void)
{
    int i;
//    suspend = true;
    Drive->ScanBus();
    combo_drive->hide();
    combo_drive->clear_items();
    for (i=0;i<Drive->drvcnt;i++)
        combo_drive->append_text(Drive->drives[i]);
    combo_drive->show();

    if (Drive->drvcnt>0)
    {
        combo_drive->set_active(0);
        Drive->SetDrive(0);
        UpdateDriveInfo();
    }
 //   suspend = false;
}

void MainWindow::UpdateDriveInfo(void)
{
    char s[100];
    int devtype;
    printf("*** Updating drive info\n");
	Drive->drive->ven_ID=0;
	Drive->drive->dev_ID=0;
	Drive->drive->mmc=0;
	devtype = Drive->inquiry();
	switch (devtype & 0xFF)
    {
		case 0x03:
    		printf("Unable to open: %s\n",Drive->drive->device);
			return;
		case 0x0F:
    		printf("Not an MMC unit: %s\n",Drive->drive->device);
			return;
	}
	Drive->convert_to_ID();
	Drive->detect_capabilities();
	Drive->detect_iface();
	Drive->drive->ven_features=0;
	Drive->drive->chk_features=0;
    Drive->detect_check_capabilities();
	info_vendor->set_label(Drive->drive->ven);
	info_model->set_label(Drive->drive->dev);
	info_firmware->set_label(Drive->drive->fw);
	//combo_commands->setCurrentItem(Drive->drive->ven_ID);
	Drive->read_buffer_capacity();
    sprintf(s,"%dkB",Drive->drive->buffer_size);
	info_buffer->set_label(s);

    info_loader->set_label(loader_list[Drive->drive->loader_id]);
	if ((Drive->drive->ven_ID == WR_PLEXTOR))
	{
		//plextor_get_TLA(Drive->drive);
		//info_tla->set_label(Drive->drive->TLA);
		//px755_do_auth(Drive->drive);
		//if (Drive->drive->dev_ID == PLEXTOR_760)
        //    drive->ven_features|=PX_ERASER;
	};
	if (Drive->get_drive_serial_number())
		info_sn->set_label(Drive->drive->serial);
    else
		info_sn->set_label("?");
	info_iface->set_label(Drive->drive->iface);
	Drive->read_rpc_state();
	info_rpc->set_label(rpc_phase[Drive->drive->rpc.phase]);
	if (Drive->drive->rpc.phase > 1)
    {
        sprintf(s,"%d",Drive->drive->rpc.region);
        if (Drive->drive->rpc.region>10)
    		info_region->set_label("None");
        else
    		info_region->set_label(s);
        sprintf(s,"%d",Drive->drive->rpc.ch_u);
		info_userchng->set_label(s);
        sprintf(s,"%d",Drive->drive->rpc.ch_v);
		info_vendorrst->set_label(s);
	} else
    {
		info_region->set_label("N/A");
		info_userchng->set_label("N/A");
		info_vendorrst->set_label("N/A");
	}
//printf("show_spindown_time(drive);\n");
/*	show_spindown_time(drive);
	if (Drive->drive->parms.spindown_idx < spindowns) {
		combo_spindown->setEnabled(true);
		combo_spindown->setCurrentItem(Drive->drive->parms.spindown_idx);
	} else {
		combo_spindown->setEnabled(false);
		combo_spindown->setCurrentItem(0);
	}
*/
    printf("Drive capabilities:       0x%08X\n",Drive->drive->capabilities);
	printf("Drive Read capabilities:  0x%08X\n",Drive->drive->rd_capabilities);
	printf("Drive Write capabilities: 0x%08X\n",Drive->drive->wr_capabilities);

    // Read capabilities
    if (Drive->drive->rd_capabilities & DEVICE_CD_R) info_cdr_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
    	else info_cdr_r->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->rd_capabilities & DEVICE_CD_RW) info_cdrw_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_cdrw_r->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->rd_capabilities & DEVICE_DVD_ROM) info_dvdrom_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdrom_r->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->rd_capabilities & DEVICE_DVD_RAM) info_dvdram_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdram_r->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->rd_capabilities & DEVICE_DVD_R) info_dvdrm_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdrm_r->set(Gtk::Stock::NO, Gtk::IconSize(1));
 	if (Drive->drive->rd_capabilities & DEVICE_DVD_RW) info_dvdrwm_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
 		else info_dvdrwm_r->set(Gtk::Stock::NO, Gtk::IconSize(1));
 	if (Drive->drive->rd_capabilities & DEVICE_DVD_R_DL) info_dvdrdlm_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
 		else info_dvdrdlm_r->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->rd_capabilities & DEVICE_DVD_PLUS_R) info_dvdrp_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdrp_r->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->rd_capabilities & DEVICE_DVD_PLUS_RW) info_dvdrwp_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdrwp_r->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->rd_capabilities & DEVICE_DVD_PLUS_R_DL) info_dvdrdlp_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdrdlp_r->set(Gtk::Stock::NO, Gtk::IconSize(1));
	//if (Drive->drive->rd_capabilities & DEVICE_DDCD_R) info_ddcdr_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
	//	else  info_ddcdr_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
	//if (Drive->drive->rd_capabilities & DEVICE_DDCD_RW) info_ddcdrw_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
	//	else info_ddcdrw_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
	if (Drive->drive->rd_capabilities & DEVICE_MRW) info_mrain_r->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_mrain_r->set(Gtk::Stock::YES, Gtk::IconSize(1));

    // Write capabilities
	if (Drive->drive->wr_capabilities & DEVICE_CD_R) info_cdr_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
    	else info_cdr_w->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->wr_capabilities & DEVICE_CD_RW) info_cdrw_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_cdrw_w->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->wr_capabilities & DEVICE_DVD_RAM) info_dvdram_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdram_w->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->wr_capabilities & DEVICE_DVD_R) info_dvdrm_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdrm_w->set(Gtk::Stock::NO, Gtk::IconSize(1));
 	if (Drive->drive->wr_capabilities & DEVICE_DVD_RW) info_dvdrwm_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
 		else info_dvdrwm_w->set(Gtk::Stock::NO, Gtk::IconSize(1));
 	if (Drive->drive->wr_capabilities & DEVICE_DVD_R_DL) info_dvdrdlm_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
 		else info_dvdrdlm_w->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->wr_capabilities & DEVICE_DVD_PLUS_R) info_dvdrp_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdrp_w->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->wr_capabilities & DEVICE_DVD_PLUS_RW) info_dvdrwp_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdrwp_w->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->wr_capabilities & DEVICE_DVD_PLUS_R_DL) info_dvdrdlp_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdrdlp_w->set(Gtk::Stock::NO, Gtk::IconSize(1));
	//if (Drive->drive->wr_capabilities & DEVICE_DDCD_R) info_ddcdr_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
	//	else  info_ddcdr_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
	//if (Drive->drive->wr_capabilities & DEVICE_DDCD_RW) info_ddcdrw_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
	//	else info_ddcdrw_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
	if (Drive->drive->wr_capabilities & DEVICE_MRW) info_mrain_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_mrain_w->set(Gtk::Stock::YES, Gtk::IconSize(1));
    

	if (Drive->drive->capabilities & CAP_REMOVABLE_MEDIA) info_removable->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else  info_removable->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_EMBEDDED_CHANGER) info_embchanger->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_embchanger->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_SIDE_CHANGE) info_sidechange->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_sidechange->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_CD_AUDIO) info_audiocdplay->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_audiocdplay->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_COMPOSITE) info_composite->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_composite->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_DIGITAL_PORT_1) info_digital1->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_digital1->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_DIGITAL_PORT_2) info_digital2->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_digital2->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_MULTISESSION) info_multisession->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_multisession->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_MODE2_FORM1) info_mode2form1->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_mode2form1->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_MODE2_FORM2)info_mode2form2->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_mode2form2->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_ISRC) info_isrcread->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_isrcread->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_UPC) info_upcread->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_upcread->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_READ_BAR_CODE) info_barcoderead->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_barcoderead->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_MORPHING) info_morphing->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_morphing->set(Gtk::Stock::NO, Gtk::IconSize(1));
    
	if (Drive->drive->capabilities & CAP_DAE) info_dae->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dae->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_ACCURATE_STREAM) info_accurate->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_accurate->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_C2) info_c2err->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_c2err->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_CD_TEXT) info_cdtext->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_cdtext->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_REAL_TIME_STREAMING) info_stream->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_stream->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_DVD_CPRM) info_dvdcprm->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdcprm->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_DVD_CSS) info_dvdcss->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_dvdcss->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_MICROCODE_UPGRADE) info_microcode->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_microcode->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_TEST_WRITE) info_testwr->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_testwr->set(Gtk::Stock::NO, Gtk::IconSize(1));
    if (Drive->drive->capabilities & CAP_SMART) info_smart->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_smart->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if ((Drive->drive->capabilities & CAP_DEFECT_MANAGEMENT)) info_defectmng->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_defectmng->set(Gtk::Stock::NO, Gtk::IconSize(1));
	if (Drive->drive->capabilities & CAP_POWER_MANAGEMENT) info_pwrmng->set(Gtk::Stock::YES, Gtk::IconSize(1));
		else info_pwrmng->set(Gtk::Stock::NO, Gtk::IconSize(1));

	if (Drive->drive->capabilities & CAP_LOCK)
    {
        Drive->get_lock();
        check_locked->set_sensitive(true);
    	if (Drive->drive->parms.status & STATUS_LOCK)
            check_locked->set_active(true);
        else
            check_locked->set_active(false);
    }
	else 
    {
        check_locked->set_sensitive(false);
        check_locked->set_active(false);
    }
	if (Drive->drive->capabilities & CAP_EJECT) button_eject->set_sensitive(true);
		else button_eject->set_sensitive(false);

    UpdateMediaInfo();
}

void MainWindow::UpdateMediaInfo()
{
	int i;
    char s[100];
//	track_info track;
//	for (i=0; i<255; i++)
//		if (sessions[i]) {delete sessions[i]; sessions[i]=NULL;}
//	push_scan_start->setEnabled(false);
//	combo_scan_speed->setEnabled(false);
//	combo_scan_speed->clear();

/*	check_rd_rate->setEnabled(false);
	check_cx->setEnabled(false);
	push_px_cx_ext->setEnabled(false);
	check_jb_cd->setEnabled(false);
	check_pie->setEnabled(false);
	check_pif->setEnabled(false);
	check_jb_dvd->setEnabled(false);
	check_fete->setEnabled(false);
	check_ta->setEnabled(false);*/

    media_disctype->set_label("No disc");
	media_layers->set_label("n/a");
	media_booktype->set_label("n/a");
	media_burner->set_label("n/a");
	media_mid->set_label("n/a");
	media_state->set_label("n/a");
	strcpy(Drive->drive->media.MID,"n/a");
	Drive->determine_disc_type();
	//print_disc_type(drive);
	Drive->get_read_speed();
    tracks_store->clear();
//	TR1G->clear();CX1G->clear();JB1G->clear();
//	TR2G->clear();CX2G->clear();JB2G->clear();
//	TR3G->clear();CX3G->clear();JB3G->clear();
//	TR4G->clear();CX4G->clear();JB4G->clear();
//	TR10->clear();TR20->clear();TR30->clear();
//	TR40->clear();TR50->clear();TR60->clear();

	//detect_speeds();
	if (Drive->drive->media.disc_type)
    {
		//check_rd_rate->setEnabled(true);
// 		if (Drive->drive->wr_capabilities)
		Drive->read_capacity();
        sprintf(s,"%dMB (%d sectors)",Drive->drive->media.capacity/512,Drive->drive->media.capacity);
		media_readsize->set_label(s);
		printf("Disc read capacity: %d sectors/%d ECC blocks/%dMB/%02d:%02d.%02dMSF\n", Drive->drive->media.capacity, Drive->drive->media.capacity/16, Drive->drive->media.capacity/512, (Drive->drive->media.capacity-75)/4500, ((Drive->drive->media.capacity)/75)%60, Drive->drive->media.capacity%75);

		Drive->read_free();
        sprintf(s,"%dMB (%d sectors)",Drive->drive->media.capacity_free/512,Drive->drive->media.capacity_free);
		media_freesize->set_label(s);
		printf("Disc free capacity: %d sectors/%d ECC blocks/%dMB/%02d:%02d.%02dMSF\n", Drive->drive->media.capacity_free, Drive->drive->media.capacity_free/16, Drive->drive->media.capacity_free/512, (Drive->drive->media.capacity_free-75)/4500, ((Drive->drive->media.capacity_free)/75)%60, Drive->drive->media.capacity_free%75);

		Drive->drive->media.capacity_total = Drive->drive->media.capacity+Drive->drive->media.capacity_free;
        sprintf(s,"%dMB (%d sectors)",Drive->drive->media.capacity_total/512,Drive->drive->media.capacity_total);
		media_totalsize->set_label(s);
		printf("Total capacity: %d sectors/%d ECC blocks/%dMB/%02d:%02d.%02dMSF\n", Drive->drive->media.capacity_total, Drive->drive->media.capacity_total/16, Drive->drive->media.capacity_total/512, (Drive->drive->media.capacity_total-75)/4500, ((Drive->drive->media.capacity_total)/75)%60, Drive->drive->media.capacity_total%75);

        Drive->get_track_list();
		if (Drive->drive->media.tracks) 
        {
    		int session=-1;
            printf("Tracks: %d\n",Drive->drive->media.tracks);
            Gtk::TreeModel::Row rowsession;
			for (i=0; i < Drive->drive->media.tracks; i++) 
            {
				if (Drive->drive->media.track[i].session<255) 
                {
				    if ((Drive->drive->media.track[i].session-1)>session) 
                    {
					    session = Drive->drive->media.track[i].session-1;
					    printf("Session %d...\n",session+1);
                        Gtk::TreeModel::iterator iter = tracks_store->append();
                        rowsession = *iter;
                        sprintf(s,"Session%02d", Drive->drive->media.track[i].session);
                        rowsession[tracks_columns.col_track] = s;
				    }
                    Gtk::TreeModel::iterator iter_child = tracks_store->append(rowsession.children());
                    Gtk::TreeModel::Row rowtrack = *iter_child;
                    rowtrack[tracks_columns.col_track] = s;
				    if (Drive->drive->media.track[i].track_mode == 2)
                    {
                        rowtrack[tracks_columns.col_type] = track_mode[Drive->drive->media.track[i].track_mode];
                        sprintf(s, " %d:%02d.%02d", Drive->drive->media.track[i].time.m, Drive->drive->media.track[i].time.s, Drive->drive->media.track[i].time.f);
                        rowtrack[tracks_columns.col_size] = s;
                        sprintf(s, " %d:%02d.%02d", Drive->drive->media.track[i].time.m, Drive->drive->media.track[i].time.s, Drive->drive->media.track[i].time.f);
                        rowtrack[tracks_columns.col_begin] = s;
                        sprintf(s," %d:%02d.%02d", Drive->drive->media.track[i].msf_end.m, Drive->drive->media.track[i].msf_end.s, Drive->drive->media.track[i].msf_end.f);
                        rowtrack[tracks_columns.col_end] = s;
                    }
				    else
                    {
                        sprintf(s, " %s/%s", track_mode[Drive->drive->media.track[i].track_mode], data_mode[Drive->drive->media.track[i].data_mode]);
                        rowtrack[tracks_columns.col_type] = s;
                        sprintf(s, " %dM", Drive->drive->media.track[i].size >> 9);
                        rowtrack[tracks_columns.col_size] = s;
					    sprintf(s, " %d", Drive->drive->media.track[i].start);
                        rowtrack[tracks_columns.col_begin] = s;
					    sprintf(s, " %d", Drive->drive->media.track[i].end);
                        rowtrack[tracks_columns.col_end] = s;
                    }
				}
				tracks_view->expand_all();
			}
            sprintf(s,"%d",Drive->drive->media.sessions);
			media_sessions->set_label(s);
            sprintf(s,"%d",Drive->drive->media.tracks);
			media_tracks->set_label(s);
		}

		media_state->set_label(disc_status_list[Drive->drive->media.dstatus]);
		media_lastses->set_label(session_status_list[Drive->drive->media.sstatus]);
		media_erasable->set_label(Drive->drive->media.erasable ? "yes" : "no" );
		//if (!drive->media.dstatus) DrawTestLimits(hres+1,hres+1);
		//if (!drive->media.sstatus) {drive->media.sessions--; drive->media.tracks--;}
		//push_scan_start->setEnabled(true);
	}
    else 
    {
		media_sessions->set_label("n/a");
		media_tracks->set_label("n/a");
		media_lastses->set_label("n/a");
		//media_sstate->set_label("n/a");
		media_totalsize->set_label("n/a");
		media_readsize->set_label("n/a");
		media_freesize->set_label("n/a");
		media_erasable->set_label("n/a");
		//DrawTestLimits(hres+1,hres+1);
	}

    UpdateDiscType();
	if ( Drive->drive->media.disc_type & DISC_DVD ) 
    {
		if (!(Drive->drive->media.disc_type & DISC_DVDROM)) 
        {
			media_mid->set_label(Drive->drive->media.MID);
			//status_MID->set_label(Drive->drive->media.MID);
			media_burner->set_label(Drive->drive->media.writer);
		}
		trate_curve->set_limits(0,hscaleDVD,0,16);
		//if (Drive->drive->media.dstatus) 
        //    check_rd_rate->setEnabled(true);
//
//		if (Drive->drive->chk_features & CHK_PIE) {
//			check_pie->setEnabled(true);
//			if ((Drive->drive->ven_ID == WR_PLEXTOR)) push_px_cx_ext->setEnabled(true);
//		}
//		if (Drive->drive->chk_features & CHK_PIF) check_pif->setEnabled(true);
//		if (Drive->drive->chk_features & CHK_JB_DVD) check_jb_dvd->setEnabled(true);
//		if (Drive->drive->chk_features & CHK_FETE) check_fete->setEnabled(true);
//		if (Drive->drive->chk_features & CHK_TA) check_ta->setEnabled(true);
//

//		if ((Drive->drive->chk_features & CHK_PIE) && (Drive->drive->media.dstatus)) check_pie->setEnabled(true);
//		if ((Drive->drive->chk_features & CHK_PIF) && (Drive->drive->media.dstatus)) check_pif->setEnabled(true);
//		if ((Drive->drive->chk_features & CHK_JB_DVD) && (Drive->drive->media.dstatus)) check_jb_dvd->setEnabled(true);
//		if ((Drive->drive->chk_features & CHK_FETE) && (!drive->media.dstatus)) check_fete->setEnabled(true);
//		if ((Drive->drive->chk_features & CHK_TA) && (Drive->drive->media.dstatus)) check_ta->setEnabled(true);
//
		UpdateBookType();
        sprintf(s,"%d",Drive->drive->media.layers);
		media_layers->set_label(s);
		//if (Drive->drive->media.dstatus) {
		//combo_scan_speed->insertItem("2x");
		//combo_scan_speed->insertItem("5x");
		//combo_scan_speed->insertItem("8x");
		//combo_scan_speed->insertItem("12x");
		//combo_scan_speed->setEnabled(true);
		//combo_scan_speed->setCurrentItem(last_dvd_scan_speed);
		//set_scan_speed("");

        /*DrawTestLimits(Drive->drive->media.capacity/(hscaleDVD*drive->media.layers), Drive->drive->media.capacity_free/(hscaleDVD*drive->media.layers));
		combo_Speed->setEnabled(true);
		g1=QString("%1G").arg(Drive->drive->media.layers*1);
		g2=QString("%1G").arg(Drive->drive->media.layers*2);
		g3=QString("%1G").arg(Drive->drive->media.layers*3);
		g4=QString("%1G").arg(Drive->drive->media.layers*4);
		TR10->set_label("4");
		TR20->set_label("8");
		TR30->set_label("12");
		TR40->set_label("16");
		TR50->set_label("20");*/
	} 
    else if ( Drive->drive->media.disc_type & DISC_CD )
    {
		if (!(Drive->drive->media.disc_type & DISC_CDROM))
        {
			media_mid->set_label(Drive->drive->media.MID);
			//status_MID->set_label(Drive->drive->media.MID);
		}
		trate_curve->set_limits(0,hscaleCD,0,60);
		
/*		if (Drive->drive->media.dstatus) check_rd_rate->setEnabled(true);

		if (Drive->drive->chk_features & CHK_CX) {
			check_cx->setEnabled(true);
			if ((Drive->drive->ven_ID == WR_PLEXTOR)) push_px_cx_ext->setEnabled(true);
		}
		if (Drive->drive->chk_features & CHK_JB_CD) check_jb_cd->setEnabled(true);
		if (Drive->drive->chk_features & CHK_FETE) check_fete->setEnabled(true);
//

//		if ((Drive->drive->chk_features & CHK_CX) && (Drive->drive->media.dstatus)) check_cx->setEnabled(true);
//		if ((Drive->drive->chk_features & CHK_JB_CD) && (Drive->drive->media.dstatus)) check_jb_cd->setEnabled(true);
//		if ((Drive->drive->chk_features & CHK_FETE) && (!drive->media.dstatus)) check_fete->setEnabled(true);
//
		combo_scan_speed->insertItem("4x");
		combo_scan_speed->insertItem("8x");
		combo_scan_speed->insertItem("24x");
		combo_scan_speed->insertItem("32x");
		combo_scan_speed->insertItem("40x");
		combo_scan_speed->setCurrentItem(last_cd_scan_speed);
		set_scan_speed("");

        if (((Drive->drive->ven_ID == WR_PLEXTOR)) && (Drive->drive->ven_features & PX_SECUREC)) {
			plextor_get_securec_state(drive);
			media_securec_used->set_label(Drive->drive->plextor.securec_disc ? "YES" : "NO");
		}
		if (((Drive->drive->ven_ID == WR_PLEXTOR)) && (Drive->drive->ven_features & PX_GIGAREC)) {
			plextor_get_gigarec(drive);
			int g=0;
			while ((gigarec_tbl[g].val!=0xFF) & (gigarec_tbl[g].val!=(Drive->drive->plextor.gigarec_disc & 0xFF))) g++;
			media_gigarec_rate->set_label(gigarec_tbl[g].name);
		}

		DrawTestLimits(Drive->drive->media.capacity/hscaleCD, Drive->drive->media.capacity_free/hscaleCD);
		combo_Speed->setEnabled(true);
		g1="176M/20min"; g2="352M/40min"; g3="528M/60min"; g4="704M/80min";
		TR10->set_label("10");
		TR20->set_label("20");
		TR30->set_label("30");
		TR40->set_label("40");
		TR50->set_label("50");
		TR60->set_label("60");
	}
	TR1G->set_label(g1);CX1G->set_label(g1);JB1G->set_label(g1);FT1G->set_label(g1);
	TR2G->set_label(g2);CX2G->set_label(g2);JB2G->set_label(g2);FT2G->set_label(g2);
	TR3G->set_label(g3);CX3G->set_label(g3);JB3G->set_label(g3);FT3G->set_label(g3);
	TR4G->set_label(g4);CX4G->set_label(g4);JB4G->set_label(g4);FT4G->set_label(g4);
//	if ( drive->media.type != Media_NoMedia ) combo_Speed->setEnabled(true);
//	if (Drive->drive->media.disc_type)
		combo_scan_speed->setEnabled(true);
	status_current_test->set_label("idle...");
	if (Drive->drive->ven_features & PX_SILENT) silent_mode_update(drive);
	if (Drive->drive->ven_features & PX_ERASER) {
		drive->plextor.plexeraser=PLEXERASER_QUICK;
		group_plexeraser->setEnabled(true);
		radio_pxerase_quick->setChecked(true);
		if (Drive->drive->media.disc_type & (DISC_CDR | DISC_DVDplusR | DISC_DVDminusR))
			push_pxerase->setEnabled(true);
		else
			push_pxerase->setEnabled(false);*/
	}

	if (Drive->drive->capabilities & CAP_LOCK)
    {
        Drive->get_lock();
        check_locked->set_sensitive(true);
    	if (Drive->drive->parms.status & STATUS_LOCK)
            check_locked->set_active(true);
        else
            check_locked->set_active(false);
    }
	else 
    {
        check_locked->set_sensitive(false);
        check_locked->set_active(false);
    }
}

void MainWindow::UpdateDiscType()
{
	if (Drive->drive->media.disc_type & DISC_DVD)	
    {
		switch (Drive->drive->media.disc_type) 
        {
			case DISC_DVDplusR:
				//status_disctype->set_label("DVD+R");
				media_disctype->set_label("DVD+R"); break;
			case DISC_DVDplusRW:
				//status_disctype->set_label("DVD+RW");
				media_disctype->set_label("DVD+RW"); break;
			case DISC_DVDplusRDL:
				//status_disctype->set_label("DVD+R DL");
				media_disctype->set_label("DVD+R DL"); break;
			case DISC_DVDminusR:
				//status_disctype->set_label("DVD-R Sequential");
				media_disctype->set_label("DVD-R Sequential"); break;
			case DISC_DVDminusRWS:
				//status_disctype->set_label("DVD-RW Sequential");
				media_disctype->set_label("DVD-RW Sequential"); break;
			case DISC_DVDminusRWR:
				//status_disctype->set_label("DVD-RW Restricted Overwrite");
				media_disctype->set_label("DVD-RW Restricted Overwrite"); break;
			case DISC_DVDminusRDL:
				//status_disctype->set_label("DVD-R DL Sequential");
				media_disctype->set_label("DVD-R DL Sequential"); break;
			case DISC_DVDROM:
				//status_disctype->set_label("DVD-ROM");
				media_disctype->set_label("DVD-ROM"); break;
			default:
				//status_disctype->set_label("DVD, <unknown type>");
				media_disctype->set_label("DVD, <unknown type>");
		}
		button_start->set_sensitive(true);
	} else 
	if (Drive->drive->media.disc_type & DISC_CD) 
    {
		switch (Drive->drive->media.disc_type & DISC_CD) 
        {
			case DISC_CDROM:
				//status_disctype->set_label("CD-ROM");
				media_disctype->set_label("CD-ROM"); break;
			case DISC_CDR:
				//status_disctype->set_label("CD-R");
				media_disctype->set_label("CD-R"); break;
			case DISC_CDRW:
			switch (Drive->drive->media.disc_type & DISC_CDRWSUBT) 
            {
				case DISC_CDRWMS:
					//status_disctype->set_label("CD-RW, Multi Speed");
					media_disctype->set_label("CD-RW, Multi Speed"); break;
				case DISC_CDRWHS:
					//status_disctype->set_label("CD-RW, High Speed");
					media_disctype->set_label("CD-RW, High Speed"); break;
				case DISC_CDRWUS:
					//status_disctype->set_label("CD-RW, Ultra Speed");
					media_disctype->set_label("CD-RW, Ultra Speed"); break;
				case DISC_CDRWUSP:
					//status_disctype->set_label("CD-RW, Ultra Speed+");
					media_disctype->set_label("CD-RW, Ultra Speed+"); break;
				default:
					//status_disctype->set_label("CD-RW, <unknown subtype>");
					media_disctype->set_label("CD-RW, <unknown subtype>"); break;
			}; break;
			default:
				//status_disctype->set_label("CD, <unknown type>");
				media_disctype->set_label("CD, <unknown type>");
		}
		button_start->set_sensitive(true);
	} else 
	if (!Drive->drive->media.disc_type) 
    {
		//status_disctype->set_label("No disc");
		media_disctype->set_label("No disc");
		button_start->set_sensitive(false);
	} else 
    {
		//status_disctype->set_label("unknown");
		media_disctype->set_label("unknown");
		button_start->set_sensitive(false);
	}
	button_stop->set_sensitive(false);
}

void MainWindow::UpdateBookType()
{
    char s[100];
    sprintf(s,"%s [rev %d]",_book_type_tbl[(Drive->drive->media.book_type&0xF0)>>4],Drive->drive->media.book_type&0x0F);
	media_booktype->set_label(s);	
}
